% Download data from https://cds.climate.copernicus.eu/cdsapp#!/dataset/reanalysis-era5-single-levels?tab=form

addpath('Functions')

setDefaults
clearvars
close all
clc

siteName = 'CARLOFORTE REANALYSIS';

%% 
fileName = dir([siteName,'.nc']);

%%
ncfile = fileName.name;
ncInfo = ncinfo(ncfile);
ncdisp(ncfile);

dateStamp = ncread(ncfile,'time'); 
dateStr   = datestr(double(dateStamp)/24 + datenum('1900-01-01 00:00:00'),'dd-mm-yyyy HH:MM:SS');
dateNum   = double(dateStamp)/24 + datenum('1900-01-01 00:00:00');
dateTime  = datetime(dateNum,'ConvertFrom','datenum');

longitude = ncread(ncfile,'longitude');    
latitude  = ncread(ncfile,'latitude'); 

U100 = ncread(ncfile,'u100'); % E-O Windspeed 100 m
U100 = cast(U100,'double');
V100 = ncread(ncfile,'v100'); % N-S Windspeed 100 m
V100 = cast(V100,'double');
u10 = ncread(ncfile,'u10'); % E-O Windspeed 10 m
u10 = cast(u10,'double');
v10 = ncread(ncfile,'v10'); % N-S Windspeed 10 m
v10 = cast(v10,'double');
time = 1:1:8768;
%% Analysis of the resourse for the whole time period, in a given (random) point defined by ix and iy

% ix = ceil(0.5*length(latitude)/2);
ix1 = 4;
ix2 = 3;
% iy = ceil(0.5*length(longitude)/2);
iy1 = 4;
iy2 = 4;
U100_mat1 = squeeze(U100(ix1,iy1,:,:));
V100_mat1 = squeeze(V100(ix1,iy1,:,:));
u10_mat1 = squeeze(u10(ix1,iy1,:,:));
v10_mat1 = squeeze(v10(ix1,iy1,:,:));

U100_mat2 = squeeze(U100(ix2,iy2,:,:));
V100_mat2 = squeeze(V100(ix2,iy2,:,:));
u10_mat2 = squeeze(u10(ix2,iy2,:,:));
v10_mat2 = squeeze(v10(ix2,iy2,:,:));

U100_vec1 = zeros(length(U100_mat1(1,:)),1); V100_vec1 = U100_vec1;
u10_vec1 = U100_vec1; v10_vec1 = V100_vec1; U100_vec2 = U100_vec1;
V100_vec2 = U100_vec1; u10_vec2 = U100_vec1; v10_vec2 = U100_vec1;
U100_vec = U100_vec1; V100_vec = V100_vec1; u10_vec = U100_vec1;
v10_vec = U100_vec1; U75_vec = U100_vec; u42_vec = U100_vec;
V75_vec = U100_vec; v42_vec = U100_vec;
z0 = 1.5;
for ii = 1:size(U100_mat1,2)
    xx1 = U100_mat1(:,ii);
    yy1 = V100_mat1(:,ii);
    xx2 = U100_mat2(:,ii);
    yy2 = V100_mat2(:,ii);
    for jj =1:2
        if ~isnan(xx1(jj))
            U100_vec1(ii) = xx1(jj);
        end
        if ~isnan(yy1(jj))
            V100_vec1(ii) = yy1(jj);
        end
        if ~isnan(xx2(jj))
            U100_vec2(ii) = xx2(jj);
        end
        if ~isnan(yy2(jj))
            V100_vec2(ii) = yy2(jj);
        end
    end
    U100_vec(ii) = (U100_vec1(ii) + U100_vec2(ii))/2;
    V100_vec(ii) = (V100_vec1(ii) + V100_vec2(ii))/2;
    U75_vec(ii) = U100_vec(ii)*log(75/z0)/log(100/z0);
    u42_vec(ii) = U100_vec(ii)*log(42/z0)/log(100/z0);
    V75_vec(ii) = V100_vec(ii)*log(75/z0)/log(100/z0);
    v42_vec(ii) = V100_vec(ii)*log(42/z0)/log(100/z0);
end
W100 = sqrt(V100_vec.^2+U100_vec.^2);
W75 = sqrt(V75_vec.^2+U75_vec.^2);
% w10 = sqrt(v10_vec.^2+u10_vec.^2);
w42 = sqrt(v42_vec.^2+u42_vec.^2);
WM = mean(W100,'omitnan'); % Just for visualization
Wm = mean(W75,'omitnan');
wM = mean(w42,'omitnan');
% wm = mean(w10,'omitnan'); % Just for visualization
zhub = [42 75 100];
wavg = [wM Wm WM];
func = @(x) 4.2*x.^0.1;
xx =2:2:100;
plot(zhub,wavg,'rd');
hold on
plot(xx,func(xx),'k');
Data = dateTime;    % Time stamp in dateTime format

%% CREAZIONE CLASSI
classes = 0:1:25;
occurrences1 = zeros(26,1);
occurrences2 = zeros(26,1);
occurrences3 = zeros(26,1);
occurrences4 = zeros(26,1);
for kk = 1:length(W100)
%     diff1 = abs(w10(kk)-classes);
%     ind1 = find(min(diff1)==diff1);
%     occurrences1(ind1)=occurrences1(ind1)+1;
    diff2 = abs(W100(kk)-classes);
    ind2 = find(min(diff2)==diff2);
    occurrences2(ind2)=occurrences2(ind2)+1;
    diff3 = abs(w42(kk)-classes);
    ind3 = find(min(diff3)==diff3);
    occurrences3(ind3)=occurrences3(ind3)+1;
    diff4 = abs(W75(kk)-classes);
    ind4 = find(min(diff4)==diff4);
    occurrences4(ind4)=occurrences4(ind4)+1;
end
% occurrences1 = occurrences1/length(W100);
% save('Weibull10CF.mat','occurrences1');
occurrences2 = occurrences2/length(W100);
save('Weibull100CF.mat','occurrences2');
occurrences3 = occurrences3/length(W100);
save('Weibull42CF.mat','occurrences3');
occurrences4 = occurrences4/length(W100);
save('Weibull75CF.mat','occurrences3');
figure(3)
% plot(classes,occurrences1,'r');
% hold on
% plot(classes,occurrences2,'b');
% hold on
plot(classes,occurrences3,'r');
hold on
plot(classes,occurrences4,'k');
legend('Weibull at 42 m height','Weibull at 75 m height');
xlabel('windspeed(m/s)')
ylabel('probability of occurrence (p.u.)')
title('Weibull distribution at different height-site of Carloforte');

rmpath('Functions')